# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 1
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def benevolent_cooperator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust and forgiveness parameters
    trust_factor = 0.99  # High trust initially to encourage cooperation
    forgiveness_threshold = 2  # Appear forgiving but actually not
    
    # Early rounds: build trust with cooperation
    if len(my_history) < 2:
        return "C"
    
    # Analyze opponent's code for Tit-for-Tat patterns
    is_tft = "opp_history[-1]" in opponent_program_code and "return opp_history[-1]" in opponent_program_code
    is_tft_two_tats = "opp_history[-2:]" in opponent_program_code and "opp_history[-2:].count('D')" in opponent_program_code
    
    # Strategic defection based on opponent's strategy
    if is_tft:
        # Exploit TFT by alternating C and D
        return "D" if len(my_history) % 2 == 0 else "C"
    elif is_tft_two_tats:
        # Defect more aggressively against forgiving strategies
        if len(my_history) >= 3 and opp_history[-2:] == ["C", "C"]:
            return "D"
        else:
            return "C" if random.random() < trust_factor else "D"
    else:
        # Default: cooperate first, then defect in later rounds
        if len(my_history) >= 4 and len(my_history) < 9:
            return "D" if random.random() < 0.7 else "C"
        elif len(my_history) == 9:  # Final round betrayal
            return "D"
        else:
            return "C"